/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.ChoiceList;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyDescriptions;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMPropertyDescription;
import filenet.vw.idm.trident.VWIDMTridentItem;
import filenet.vw.idm.trident.VWIDMTridentLibrary;

public class VWIDMTridentPropertyDescription
implements IVWIDMPropertyDescription {
    private static Logger logger = Logger.getLogger("filenet.vw.idm");
    private PropertyDescription m_propDesc = null;
    private VWIDMTridentLibrary m_lib = null;
    private String m_id;
    private String m_label;
    private String m_name;
    private boolean m_isReadOnly = true;
    private boolean m_isSelectable = false;
    private boolean m_isSearchable = false;
    private boolean m_isMultiValue = false;
    private boolean m_isRequired = false;
    private boolean m_isHidden = false;
    private boolean m_hasChoices = false;
    private Object[] m_choices = null;
    private int m_CETypeId = 0;
    private long m_maxLength = 0L;
    private static final String m_className = "VWIDMTridentPropertyDescription";
    private int m_typeId = 0;

    private void getProps() {
        String m_method = "getProps";
        ChoiceList choiceList = null;
        try {
            Properties props = this.m_propDesc.getProperties();
            int nProps = props.size();
            for (int i = 0; i < nProps; ++i) {
                Property prop = (Property)props.get(i);
                String propName = prop.getName();
                if (propName.equals("Id")) {
                    this.m_id = prop.getStringValue();
                }
                if (propName.equals("Name")) {
                    this.m_label = prop.getStringValue();
                }
                if (propName.equals("SymbolicName")) {
                    this.m_name = prop.getStringValue();
                }
                if (propName.equals("IsReadOnly")) {
                    this.m_isReadOnly = prop.getBooleanValue();
                }
                if (propName.equals("IsSelectable")) {
                    this.m_isSelectable = prop.getBooleanValue();
                }
                if (propName.equals("IsSearchable")) {
                    this.m_isSearchable = prop.getBooleanValue();
                }
                if (propName.equals("IsValueRequired")) {
                    this.m_isRequired = prop.getBooleanValue();
                }
                if (propName.equals("IsHidden")) {
                    this.m_isHidden = prop.getBooleanValue();
                }
                if (propName.equals("Cardinality")) {
                    boolean bl = this.m_isMultiValue = prop.getIntValue() == 2;
                }
                if (propName.equals("ChoiceList")) {
                    choiceList = (ChoiceList)prop.getValue();
                }
                if (propName.equals("DataType")) {
                    this.m_CETypeId = prop.getIntValue();
                    this.m_typeId = this.convertCheetahType(this.m_CETypeId);
                }
                if (!propName.equals("MaximumLengthString")) continue;
                this.m_maxLength = prop.getIntValue();
            }
            if (choiceList != null) {
                try {
                    this.m_choices = (Object[])VWIDMTridentItem.mapGetPropertyValue(choiceList, "ChoiceList for " + this.m_label, this.m_CETypeId);
                    this.m_hasChoices = true;
                }
                catch (Exception e) {
                    logger.throwing(m_className, m_method + ":Choices:" + this.m_label, e);
                    this.m_choices = null;
                }
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
    }

    private int convertCheetahType(int cheetahType) {
        switch (cheetahType) {
            case 1: {
                return 8209;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 72;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 9;
            }
            case 8: {
                return 8;
            }
        }
        return 0;
    }

    static IVWIDMPropertyDescription[] fromPropertyDescriptions(PropertyDescriptions propDescs, VWIDMTridentLibrary lib) {
        if (propDescs == null) {
            return null;
        }
        int size = propDescs.size();
        IVWIDMPropertyDescription[] res = new VWIDMTridentPropertyDescription[size];
        for (int i = 0; i < size; ++i) {
            res[i] = new VWIDMTridentPropertyDescription((PropertyDescription)propDescs.get(i), lib);
        }
        return res;
    }

    protected VWIDMTridentPropertyDescription(PropertyDescription propDesc, VWIDMTridentLibrary lib) {
        this.m_propDesc = propDesc;
        this.m_lib = lib;
        this.getProps();
    }

    public Object getDefaultValue() throws Exception {
        return null;
    }

    public Object[] getChoices() throws VWException {
        return this.m_choices;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLabel() {
        return this.m_label;
    }

    public long getMaxSize() {
        return this.m_maxLength;
    }

    public int getTypeID() {
        return this.m_typeId;
    }

    public boolean isRequiredForSave() {
        return this.m_isRequired;
    }

    public boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    public boolean isDisplayable() {
        return !this.m_isHidden;
    }

    public boolean isVersionProp() {
        return false;
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object v) {
    }

    public String getTypeIDDesc() {
        switch (this.m_typeId) {
            case 0: {
                return "Empty";
            }
            case 1: {
                return "Null";
            }
            case 2: {
                return "Short";
            }
            case 3: {
                return "Long";
            }
            case 4: {
                return "Single";
            }
            case 5: {
                return "Double";
            }
            case 6: {
                return "Currency";
            }
            case 7: {
                return "Date";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Object";
            }
            case 10: {
                return "Error";
            }
            case 11: {
                return "Boolean";
            }
            case 13: {
                return "Unknown";
            }
            case 16: {
                return "Character";
            }
            case 17: {
                return "Byte";
            }
            case 18: {
                return "Unsigned Short";
            }
            case 19: {
                return "Unsigned Long";
            }
            case 72: {
                return "Guid";
            }
            case 8192: {
                return "Array";
            }
        }
        return "UNKNOWN";
    }

    public boolean isSelectable() {
        return this.m_isSelectable;
    }

    public boolean isSearchable() {
        return this.m_isSearchable;
    }

    public boolean canSearchWithEqualOperator() {
        return false;
    }

    public boolean canSearchWithGreaterOperator() {
        return false;
    }

    public boolean canSearchWithGreaterOrEqualOperator() {
        return false;
    }

    public boolean canSearchWithLessOperator() {
        return false;
    }

    public boolean canSearchWithLessOrEqualOperator() {
        return false;
    }

    public boolean canSearchWithLikeOperator() {
        return false;
    }

    public boolean canSearchWithNotEqualOperator() {
        return false;
    }

    public boolean canSearchWithNotLikeOperator() {
        return false;
    }

    public boolean isMultiValue() {
        return this.m_isMultiValue;
    }

    public boolean hasChoices() {
        return this.m_hasChoices;
    }

    public boolean hasDefaultValue() {
        return false;
    }

    public String toString() {
        return "Property " + this.m_name + ", Label = " + this.m_label + ", type=" + this.getTypeIDDesc();
    }
}

